@extends('admin.layout.dashboard-template')
@section('content')
<style>
    .fee-box {
        border: 1px solid #eee;
        margin-bottom: 30px;
        padding: 30px;
        border-radius: 21px;
        background: #f6f5f5;
    }
</style>
<div class="page-wrapper">
    <div class="content">

        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item"><a href="{{route('admin.assessment')}}">Assessment</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Edit Assessment</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <form id="addService" action="{{ route('admin.update-assessment') }}">
                            @csrf

                            <div class="row">
                                <div class="col-12">
                                    <div class="form-heading">
                                        <h4>Edit Assessment</h4>
                                    </div>
                                </div>
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Title <span class="login-danger">*</span></label>
                                        <input class="form-control" name="title" value="{{$data->title}}" type="text" required>
                                    </div>
                                </div>

                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-top-form">
                                        <label class="local-top">Image <span class="login-danger">*</span></label>
                                        <!-- <div class="settings-btn upload-files-avator"> -->
                                        <input type="file" accept="image/*" name="image" id="file" onchange="readURL(this);" class="form-control">
                                        <!-- <label for="file" class="upload">Choose File</label> -->
                                        <!-- </div> -->
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-2">
                                    <div class="form-group local-top-form">
                                        <img width="100" height="80" src="{{asset('assets/uploads/assessment/' . $data->image)}}" class="preview" alt="">
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-6">
                                    <div class="form-group summer-mail">
                                        <label>Time <span class="login-danger">*</span></label>
                                        <input class="form-control" name="time" value="{{$data->time_duration}}" required type="text" placeholder="5-10 mins">
                                    </div>
                                </div>
                                @php
                                $ids=json_decode($data->recommended_therapist);
                                @endphp
                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        <label>Recommended therapist<span class="login-danger">*</span></label>

                                        <select class="form-control select chosen-select" name="provider[]" id="provider" required="select therapist" multiple="multiple">
                                            @foreach(App\Models\Therapist::select('id', 'full_name')->orderBy('full_name', 'ASC')->get() as $item)
                                            @if(empty($ids))

                                            <option value="{{$item->id}}">{{$item->full_name}}</option>
                                            @else

                                            @if(in_array($item->id, $ids))

                                            <option value="{{$item->id}}" selected>{{$item->full_name}} </option>
                                            @else
                                            <option value="{{$item->id}}">{{$item->full_name}} </option>
                                            @endif

                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>

                                <div class="col-12 col-md-12 col-xl-12">
                                    <div class="form-group local-forms">
                                        @php
                                        $ids=json_decode($data->recommended_blogs);
                                        @endphp
                                        <label>Recommended Blogs<span class="login-danger">*</span></label>
                                        <select class="form-control select chosen-select" name="blogs[]" id="blogs" required placeholder="select blogs" multiple="multiple">
                                            @foreach(App\Models\Blog::select('id', 'title')->orderBy('title', 'ASC')->get() as $item)
                                            @if(empty($ids))

                                            <option value="{{$item->id}}">{{$item->title}}</option>
                                            @else

                                            @if(in_array($item->id, $ids))

                                            <option value="{{$item->id}}" selected>{{$item->title}} </option>
                                            @else
                                            <option value="{{$item->id}}">{{$item->title}} </option>
                                            @endif

                                            @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Assessment Questions an Answer</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>
                                @foreach($data->questions as $item)
                                <div class="fee-box " id="remove-row">
                                    <div class="row question" id="question1">
                                        <div class="col-12 col-md-10 col-xl-11">
                                            <div class="form-group local-forms">
                                                <label>Question <span class="login-danger">*</span></label>
                                                <input class="form-control" name="question[]" value="{{$item->question}}" required type="text">
                                                <input type="hidden" name="question_id" value="{{$item->id}}">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="page-table-header mb-5">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <div class="doctor-table-blk">
                                                    <h3> Answers</h3>

                                                </div>
                                            </div>
                                            <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                <a href="javascript:void(0);" title="Add more fee details" data-id="1" class="btn btn-primary add-answer ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                            </div>
                                        </div>
                                    </div>

                                    @foreach($item->answer as $answer)
                                    <div class="answer" id="remove-row-answer1">
                                        <div class="row answer1">
                                            <div class="col-12 col-md-8 col-xl-9">
                                                <div class="form-group local-forms">
                                                    <label>Answer <span class="login-danger">*</span></label>
                                                    <input class="form-control" name="answer[]" value="{{$answer->answer}}" required type="text" placeholder="Enter answer">
                                                    <input type="hidden" name="answer_id" value="{{$answer->id}}">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-2">
                                                <div class="form-group local-forms">
                                                    <label>Rate<span class="login-danger">*</span></label>
                                                    <input class="form-control" name="rate[]" required type="text" value="{{$answer->rate}}" placeholder="Enter rate">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-1">
                                                <div class="add-group">
                                                    <a href=" javascript:void(0);" data-id="1" class=" btn btn-primary ms-2 remove-answer"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                                </div>
                                            </div>

                                        </div>

                                    </div>
                                    @endforeach
                                    <div id="more-answer1"></div>
                                </div>
                                @endforeach

                                <div id="more-fee"></div>

                            </div>


                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="card card-table show-entire">
                                        <div class="card-body">

                                            <div class="page-table-header mb-2">
                                                <div class="row align-items-center">
                                                    <div class="col">
                                                        <div class="doctor-table-blk">
                                                            <h3>Assessment Rate Range settings</h3>

                                                        </div>
                                                    </div>
                                                    <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                        <a href="javascript:void(0);" title="Add more fee details" class="btn btn-primary add-settings ms-2"><img src="{{asset('assets/img/icons/plus.svg')}}" alt></a>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="fee-box " id="remove-row-settings">
                                    @foreach($data->settings as $item)
                                    <div class="row settings">
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>start rate<span class="login-danger">*</span></label>
                                                <input type="hidden" name="settings_id" value="{{$item->id}}">
                                                <input class="form-control" name="start_rate[]" value="{{$item->start_rate}}" type="text">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>End Rate<span class="login-danger">*</span></label>
                                                <input class="form-control" name="end_rate[]" value="{{$item->end_rate}}" type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-6 col-xl-7 ">
                                            <div class="form-group local-forms">
                                                <label>Comment/ Status<span class="login-danger">*</span></label>
                                                <input class="form-control" name="comment[]" value="{{$item->status}}" type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove-settings" class=" btn btn-primary ms-2"> <img src="{{asset('assets/img/icons/trash.svg')}}" alt> </a>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                                <div id="more-settings"></div>

                            </div>


                            <div class="row">
                                <div class="col-12">
                                    <div class="doctor-submit text-end">
                                        <button type="submit" class="btn btn-primary submit-form me-2">Save</button>
                                        <button type="submit" class="btn btn-primary cancel-form">Cancel</button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(".chosen-select").select2({
            multiple: true
        });
        $('body').on('click', '.add', function(e) {
            var count = $('.question').length;
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.questions-html') }}",
                data: {
                    count: count
                },
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-fee').append(result);
                }
            });
        });

        $('body').on('click', '.add-answer', function(e) {
            var count = $(this).data('id');

            var answer_count = $('.answer' + count).length + 1;
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.answer-html') }}",
                method: "GET",
                data: {
                    qcount: count,
                    count: answer_count
                },
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-answer' + count).append(result);
                }
            });
        });

        $('body').on('click', '.add-settings', function(e) {
            e.preventDefault();
            $("#js-loader").fadeIn();
            $.ajax({
                url: "{{ route('admin.settings-html') }}",
                method: "GET",
                success: function(result) {
                    $("#js-loader").fadeOut();
                    $('#more-settings').append(result);
                }
            });
        });
        $('body').on('click', '#remove', function(e) {
            $(this).closest("#remove-row").remove();
            // $('#remove-row').hide('slow');
        });

        $('body').on('click', '.remove-answer', function(e) {
            var count = $(this).data('id');
            $(this).closest("#remove-row-answer" + count).remove();
        });
        $('body').on('click', '#remove-settings', function(e) {
            $(this).closest("#remove-row-settings").remove();
            // $('#remove-row').hide('slow');
        });
        $('#addService').submit(function(e) {
            e.preventDefault();
            var url = $(this).attr("action");
            $("#js-loader").fadeIn();
            let formData = new FormData(this);
            $.ajax({
                type: 'POST',
                url: url,
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $("#js-loader").fadeOut();
                    if (data == true) {
                        toastr.success('Assessment Added Successfully');
                    } else {
                        toastr.error('Something went Wrong');
                    }
                },
                error: function(err) {
                    // Your Error Message
                    toastr.error(err);
                }
            });
        });
    </script>
    @endsection